﻿using System.Collections.Generic;
using System.Collections;
using System;

class Triple<T>
{
    T x, y, z;
    public Triple(T x, T y, T z)
    {
        this.x = x; this.y = y; this.z = z;
    }
    public IEnumerator<T> GetEnumerator()
    {
        return new TripleEnumerator<T>(this);
    }
    public class TripleEnumerator : IEnumerator
    {
        int current = 0;
        Triple<T> triple;
        public TripleEnumerator(Triple<T> triple)
        {
            this.triple = triple;
        }
        public void Dispose() { } // Do nothing.  No resources 
        // are used.
        public bool MoveNext()
        {
            if (current == 3) return false;
            else
            {
                ++current;
                return true;
            }
        }
        public void Reset() { current = 0; }
        public object Current
        {
            get
            {
                switch (current)
                {
                    case 1: return triple.x;
                    case 2: return triple.y;
                    case 3: return triple.z;
                    default:
                        throw new InvalidOperationException();
                }
            }
        }
    }
    class TripleEnumerator<U> :
            Triple<U>.TripleEnumerator, IEnumerator<U>
    {
        public TripleEnumerator(Triple<U> triple) :
            base(triple) { }
        public new U Current
        {
            get { return (U)base.Current; }
        }
    }
}
